#!/bin/sh

MASTER_PAGE_ESXI_CONF_RESULT_MSG=""
MASTER_PAGE_ESXI_CONF_RESULT_OK=0
MASTER_PAGE_ESXI_CONF_RESULT_ERROR=1

MASTER_PAGE_ESXI_CONF_RESULT_CODE=${MASTER_PAGE_ESXI_CONF_RESULT_ERROR}
MASTER_PAGE_ESXI_CONF_RESULT_ROLLING=0

master_page_esxi_conf() 
{
	debug_print "${0}" "${LINENO}" 'in function "master_page_esxi_conf"'

	local item_number=7
	local menu_list=""
	
	for (( i=1; i<=$item_number; i=i+1 ))
	do
		eval menu_item=\$MASTER_PAGE_ESXI_CONF_ITEM_$i
		menu_list="$menu_list$i \"$menu_item\" "
	done

	tp_menu_ok_cancel \
	"${MASTER_PAGE_ESXI_CONF_TITLE}" \
	"${MASTER_PAGE_ESXI_CONF_TEXT}" \
	"${MASTER_PAGE_ESXI_CONF_LABEL_OK}" \
	"${MASTER_PAGE_ESXI_CONF_LABEL_CANCEL}" \
	"${menu_list}"

	# no error cases
	MASTER_PAGE_ESXI_CONF_RESULT_CODE=${MASTER_PAGE_ESXI_CONF_RESULT_OK}
	if [ "${TP_MENU_OK_CANCEL_RESULT_CODE}" == "${TP_MENU_OK_CANCEL_RESULT_CANCEL}" ]; then
		MASTER_PAGE_ESXI_CONF_RESULT_ROLLING=-1
		return
	fi
	
	MASTER_PAGE_ESXI_CONF_RESULT_ROLLING=0

	local pages_array=""
	case ${TP_MENU_OK_CANCEL_RESULT_SELECT} in
		1) pages_array="master_page_esxi_info_conf" ;;
		2) pages_array="master_page_ms_dhcp_or_static master_page_ms_network_conf" ;;
		3) pages_array="master_page_sb_internet_conn master_page_nat_dhcp_or_static master_page_nat_network_conf";;
		4) 	# Check if internet_connection is enabled in dtascfg
			if [ "${RT_NAT_INTERNET_CONN:=$conf_nat_internet_conn}" == "0" ]; then
				pages_array="master_page_nat_no_conn_warning"
			else
				pages_array="master_page_nat_dhcp_or_static master_page_nat_network_conf" 
			fi
			;;
		5) pages_array="master_page_display_api_key" ;;
		6) pages_array="master_page_accounts_mngt" ;;
		7) pages_array="master_page_sb_reconfig" ;;
		*) ;;
	esac
	pages_roller "$pages_array"
}
